<?php

namespace Modules\Auth\app\Http\Controllers\Api\v1;

use Illuminate\Routing\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Laravel\Passport\RefreshToken;
use Laravel\Passport\Token;

class AuthApiController extends Controller
{
      /**
     * Register api
     * @return \Illuminate\Http\Response
     */
      public function register(Request $request): JsonResponse
      {
      $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email',
            'password' => 'required',
            'confirm_password' => 'required|same:password',
      ]);

      if ($validator->fails()) {

            return sendError('Validation Error.', $validator->errors());
      }
            $user = new User();
            $user->name = $request->name;
            $user->email = $request->email;
            $user->password = bcrypt($request->password);
      
            $user->save();
      return sendResponse($user, 'User register successfully.');
      
      }

      public function login(Request $request): JsonResponse
      {
      if (Auth::attempt(['email' => $request->email, 'password' => $request->password])) {

            $user = Auth::user();

            $success['id'] =  $user->id;
            $success['name'] =  $user->name;
            $success['email'] =  $user->email;
            $success['role'] =  $user->role;
            
            return sendResponse($success, 'User login successfully.');
            
      } else {

            return sendError('Unauthorised.', ['error' => 'Unauthorised']);
            }
      }

      public function logout(Request $request): JsonResponse
      {
            $request->user()->token()->revoke();

            return response()->json([
            'success' => true,
            'data' => 'unauthorized',
            'message' => 'Logged out successfully',
            ], 200);
      }
}
