<?php

namespace Modules\Auth\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Response;
use App\Helpers\AuthTokenGenerator;
use App\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Validation\ValidationException;


class OAuthApiController extends Controller
{
   public  const TYPE_PASSWORD = 'password';

   public  const TYPE_REFRESH = 'refresh_token';

   public function __construct(private AuthTokenGenerator $tokenGenerator) {}

   public function token(Request $request): array
   {
      $response = $this->tokenGenerator
            ->generateTokens($this->credentials($request), static::TYPE_PASSWORD);

      if ($response->status() !== Response::HTTP_OK) {
            
            return [
               'success'=> false,
               'status' =>401,
               'message'=>'OAuth token error.',
            ];
      }

      $data = $response->json();

      return [
            'success'=> true,
            'status' =>200,
            'message'=>'OAuth token successfully.',
            'data'=>$data,
      ];
      
   }
   
   public function refresh(Request $request): array
   {
      $response = $this->tokenGenerator
            ->generateTokens($request->only('refresh_token'), static::TYPE_REFRESH);

            if ($response->status() !== Response::HTTP_OK) {
            
               return [
                  'success'=> false,
                  'status' =>401,
                  'message'=>'OAuth token refresh error.',
               ];
            }
            $data = $response ->json();

            return [
               'success'=> true,
               'status' =>200,
               'message'=>'OAuth token refresh successfully.',
               'data'=>$data,
            ];
   }

   private function credentials(Request $request): array
   {
      return [
            'username' => $request->get('email'),
            'password' => $request->get('password'),
      ];
   }
    //===================================//

}
