<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\Auth\App\Http\Controllers\Api\v1\AuthApiController;
use \Modules\Auth\App\Http\Controllers\Api\v1\OAuthApiController;

/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

Route::middleware(['auth:api'])->group(function () {
    
});
Route::post('/login',[AuthApiController::class,'login'])->name('login');
Route::post('/register',[AuthApiController::class,'register'])->name('register');

Route::group(['prefix' => '/oauth'], function () {
    Route::post('token', [OAuthApiController::class, 'token'])->name('token');
    Route::post('refresh', [OAuthApiController::class, 'refresh'])->name('refresh');
});
//Route::post('/logout',[AuthApiController::class,'logout'])->name('logout');
Route::middleware('auth:api','administrator')->group(function () {
    Route::post('/logout',[AuthApiController::class,'logout'])->name('logout');
});