<?php

namespace Modules\Category\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Category\app\Models\Category;
use Modules\Category\app\Http\Resources\CategoryResource;
use Modules\Category\app\Http\Resources\CategoryProductResource;
use Modules\Category\app\Http\Requests\StoreCategoryRequest;
use Modules\Category\app\Http\Requests\UpdateCategoryRequest;
use App\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Intervention\Image\Facades\Image as Image;
use Modules\ServiceHelper\app\Models\Images;
use App\Enums\CategoryStatus;

class CategoryApiController extends Controller
{
    /**
     * Display a listing of the resource.
    */
    public function index(): JsonResponse
    {
        $categories = Category::all();
        return sendResponse(CategoryResource::collection($categories), 'Categories retrieved successfully.');
    }
    /**
     * Store a newly created resource in storage.
    */
    public function store(Request $request)
    {
        $category = new Category();
        $category->name = $request->name;
        $category->alias = $request->alias;   
        $filename = $request->image['filename'];
        $filepath = $request->image['pathname'];
        $folder = 'multimedia/categories/';
        if (!file_exists(public_path($folder))) {
            mkdir(public_path($folder), 777, true);
        }
        $path = $folder .$filename;
        $image = Image::make(file_get_contents($filepath))
            ->resize(320, 453)
            ->save(public_path().'/' .$path );
        $category->save();
        if ($category) {           
            $picture = new Images();
            $picture->api_server_path = config('app.url') .'/';
            $picture->folder = $folder;
            $picture->filename = $filename;
            $picture->alt_filename = $filename;
            $picture->category_id = $category->id;
            $picture->save();
        };
        return sendResponse(new CategoryResource($category), 'Category created successfully.');
    }
    /**
     * Show the specified resource.
    */   
    public function show($id)
    {
        $category = Category::findOrFail($id);
        $category->products()->get();
        if (is_null($category)) {
                return sendError(new CategoryProductResource($category), 'Category not found, status false!');
            }elseif ( $category->status == 'activated') {
            return sendResponse(new CategoryProductResource($category), 'Category retrieved successfully, status true!');
        }
    }
    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Category $id): JsonResponse
    {
        $id->update($request->all());
        return  sendResponse(new CategoryResource($id), 'Category updated successfully.');
    }
    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id): JsonResponse
    {
        $category = Category::find($id);
        $category->delete($id);
        return  sendResponse([],'Category deleted successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id): JsonResponse
    {
        DB::table('categories')
            ->where('id', $id)
            ->update(['status' => CategoryStatus::DEACTIVATED]);
        return  sendResponse(new CategoryResource($id), 'The category is successfully deactivated.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function active($id): JsonResponse
    {
        DB::table('categories')
            ->where('id', $id)
            ->update(['status' => CategoryStatus::ACTIVATED]);
        return  sendResponse(new CategoryResource($id), 'The category has been successfully activated.');
    }
    /**
     * 
     */
    public function getProductsFromCategory($id)
    {
        $category = Category::find($id);
        $category->products()->get();
        return sendResponse(new CategoryProductResource($category), 'Category products retrieved successfully.');
    }
}
