<?php

namespace Modules\Category\app\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\ServiceHelper\app\Http\Resources\ImageResource;
use Modules\Products\app\Http\Resources\ProductResource;

class CategoryProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'reference' => $this->reference,
            'name' => $this->name,
            'alias' => $this->alias,
            'image' => ImageResource::collection($this->images), 
            'products' => ProductResource::collection($this->products),
            'status' => $this->status,
            'created_at'=> $this->created_at,

        ];
    }
}
