<?php

namespace Modules\Category\app\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\ServiceHelper\app\Http\Resources\ImageResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'reference' => $this->reference,
            'name' => $this->name,
            'alias' => $this->alias,
            'image' => ImageResource::collection($this->images), 
            'status' => $this->status,
            'created_at'=> $this->created_at,

        ];
    }
}
