<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\Category\app\Http\Controllers\Api\v1\CategoryApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/
// ================ admin routes ======================== //

Route::middleware(['auth:api','administrator'])->group(function () {
    Route::post('/category',[CategoryApiController::class,'store'])->name('category.store');
    Route::put('/category/{id}',[CategoryApiController::class,'update'])->name('category.update');
    Route::delete('/category/{id}',[CategoryApiController::class,'destroy'])->name('category.destroy');
    Route::put('/category/inactive/{id}',[CategoryApiController::class,'inactive'])->name('category.inactive');
    Route::put('/category/active/{id}',[CategoryApiController::class,'active'])->name('category.active');
});
Route::get('/getProductsFromCategory/{id}',[CategoryApiController::class,'getProductsFromCategory'])->name('category.getProductsFromCategory');
// ================= api routes ============== //
//Route::get('/category',[CategoryApiController::class,'index'])->name('category.index');
//Route::middleware(['auth:api'])->group(function () {
    Route::get('/category',[CategoryApiController::class,'index'])->name('category.index');
    Route::get('/category/{id}',[CategoryApiController::class,'show'])->name('category.show');
    
//});