<?php

namespace Modules\Contact\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Contact\app\Models\Contact;
use Modules\Contact\app\Http\Resources\ContactResource;
use Modules\Contact\app\Http\Requests\StoreContactRequest;
use Modules\Contact\app\Http\Requests\UpdateContactRequest;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use App\Helpers\GenerateRandomString;
use Modules\Messager\app\Models\Messager;

class ContactApiController extends Controller
{
    public array $data = [];

    /**
     * Display a listing of the resource.
     */
    public function index(): JsonResponse
    {
        $contacts = Contact::all();

        return sendResponse(ContactResource::collection($contacts), 'Contacts retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreContactRequest $request): JsonResponse
    {
        $input = $request->all();

        $validator = Validator::make($input, [
        'country' => 'required',
        'zip_code' => 'required',
        'city' => 'required',
        'house_number' => 'required',
        'street' => 'required',
        'phone_fixe' => 'required',
        'phone_office' => 'required', 
        'email_support' => 'required',
        'email_billing' => 'required', 
        ]);

        if ($validator->fails()) {
            return sendError('Validation Error.', $validator->errors());
        }

        $data = new Contact();
        $data->country = $request->country;
        $data->zip_code = $request->zip_code;
        $data->city = $request->city;
        $data->house_number = $request->house_number;
        $data->street = $request->street;
        $data->phone_fixe = $request->phone_fixe;
        $data->phone_office = $request->phone_office;
        $data->email_support = $request->email_support;
        $data->email_billing = $request->email_billing; 
        $data->save();
        
        return sendResponse(new ContactResource($data), 'Contact created successfully.');
    }

    /**
     * Show the specified resource.
     */
    public function show($id): JsonResponse
    {
        $contact = Contact::findOrFail($id);

        if (is_null($contact)) {

                return sendError(new ContactResource($contact), 'Contact not found, status false!');

            }elseif ( $contact->status == true) {

            return sendResponse(new ContactResource($contact), 'Contact retrieved successfully, status true!');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Contact $id): JsonResponse
    {
        $id->update($request->all());

        return  sendResponse(new ContactResource($id), 'Contact updated successfully.');
    }

    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id): JsonResponse
    {
        $contact = Contact::find($id);
        $contact->delete($id);
        return  sendResponse([],'Contact deleted successfully.');
    }
}
