<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\Contact\app\Http\Controllers\Api\v1\ContactApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

// ================ admin routes ======================== //
Route::get('/contact',[ContactApiController::class,'index'])->name('contact.index');
Route::middleware(['auth:api','administrator'])->group(function () {
    //Route::get('/contact',[ContactApiController::class,'index'])->name('contact.index');
    Route::get('/contact/{id}',[ContactApiController::class,'show'])->name('contact.show');
    Route::post('/contact',[ContactApiController::class,'store'])->name('contact.store');
    Route::put('/contact/{id}',[ContactApiController::class,'update'])->name('contact.update');
    Route::delete('/contact/{id}',[ContactApiController::class,'destroy'])->name('contact.destroy');

});
