<?php

namespace Modules\Delivery\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Delivery\Database\factories\DeliveryFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Orders\app\Models\Order;


class Delivery extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table = 'deliveries';
    
    protected $fillable = [
        'id',
        'company',
        'status',
        'sum',
        'package_type',
        'client_last_name',
        'client_first_name',
        'client_email',
        'client_phone',
        'client_country',
        'client_city',
        'client_street',
        'client_zip_code',
    ];
    public function orders(): HasMany
    {
        return $this->hasMany(Order::class);
    }
}
