<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\DeliveryStatus;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('deliveries', function (Blueprint $table) {
            $table->id();
            $table->string('client_last_name')->nullable();
            $table->string('client_first_name')->nullable();
            $table->string('client_email')->nullable();
            $table->string('client_phone')->nullable();
            $table->string('client_country')->nullable();
            $table->string('client_city')->nullable();
            $table->string('client_street')->nullable();
            $table->string('client_zip_code')->nullable();
            $table->string('company');
            $table->decimal('sum', 8, 2);
            $table->string('package_type');
            $table->enum('status', DeliveryStatus::TYPES)->default(DeliveryStatus::IN_PROGRESS);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('deliveries');
    }
};
