<?php

namespace Modules\Department\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Department\app\Models\Department;
use Modules\Department\app\Http\Resources\DepartmentResource;
use Modules\Department\app\Http\Requests\StoreDepartmentRequest;
use Modules\Department\app\Http\Requests\UpdateDepartmentRequest;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Helpers\GenerateRandomString;
use App\Enums\DepartmentStatus;

class DepartmentApiController extends Controller
{
    public array $data = [];

    /**
     * Display a listing of the resource.
     */
    public function index(): JsonResponse
    {
        $departments = Department::all();
        return sendResponse(DepartmentResource::collection($departments), 'Departments retrieved successfully.');
    }
    

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request): JsonResponse
    {
    
        $data = new Department();
        $data->name = $request->name;
        $data->alias = $request->alias;
        $data->save();

        return sendResponse(new DepartmentResource($data), 'Department created successfully.');
    }

    /**
     * Show the specified resource.
     */
    public function show($id): JsonResponse
    {
        $department = Department::findOrFail($id);

        if (is_null($department)) {

                return sendError(new DepartmentResource($department), 'Department not found, status false!');

            }elseif ( $department->status == true) {

            return sendResponse(new DepartmentResource($department), 'Department retrieved successfully, status true!');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Department $id): JsonResponse
    {
        $id->update($request->all());

        return  sendResponse(new DepartmentResource($id), 'Department updated successfully.');
    }

    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id): JsonResponse
    {
        $department = Department::find($id);
        $department->delete($id);
        return  sendResponse([],'Department deleted successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id): JsonResponse
    {
        DB::table('departments')
            ->where('id', $id)
            ->update(['status' => DepartmentStatus::DEACTIVATED]);

        return  sendResponse(new DepartmentResource($id), 'The department is successfully deactivated.');
    }

    /**
     * Update the specified resource in storage.
     */

    public function active($id): JsonResponse
    {
        DB::table('departments')
            ->where('id', $id)
            ->update(['status' => DepartmentStatus::ACTIVATED]);

        return  sendResponse(new DepartmentResource($id), 'The department has been successfully activated.');
    }

}
