<?php

namespace Modules\Department\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Department\Database\factories\DepartmentFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Modules\Category\app\Models\Category;
use Modules\Products\app\Models\Product;

class Department extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table = "departments";
    
    protected $fillable = [
        'id',
        'name',
        'alias',
        'status'
    ];
    public function categories(): HasMany
    {
        return $this->hasMany(Category::class);
    }
    public function products(): HasMany
    {
        return $this->hasMany(Product::class);
    }
}
