<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\Department\app\Http\Controllers\Api\v1\DepartmentApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

// ================ admin routes ======================== //

Route::middleware(['auth:api','administrator'])->group(function () {
    Route::get('/department',[DepartmentApiController::class,'index'])->name('department.index');
    Route::get('/department/{id}',[DepartmentApiController::class,'show'])->name('department.show');
    Route::post('/department',[DepartmentApiController::class,'store'])->name('department.store');
    Route::put('/department/{id}',[DepartmentApiController::class,'update'])->name('department.update');
    Route::delete('/department/{id}',[DepartmentApiController::class,'destroy'])->name('department.destroy');
    Route::put('/department/inactive/{id}',[DepartmentApiController::class,'inactive'])->name('department.inactive');
    Route::put('/department/active/{id}',[DepartmentApiController::class,'active'])->name('department.active');
});
