<?php

namespace Modules\Livrason\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Http\JsonResponse;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Modules\ServiceHelper\app\Models\Images;
use Modules\Livrason\app\Http\Resources\LivrasonResource;
use Modules\Livrason\app\Models\Livrason;
use Intervention\Image\Facades\Image as Image;
use Illuminate\Support\Facades\DB;
use App\Enums\LivrasonStatus;

class LivrasonApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $livrasons = Livrason::all();
        return sendResponse(LivrasonResource::collection($livrasons), 'Livrasons company retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $livrason = new Livrason();

        $livrason->company = $request->company;
        $livrason->base_price = $request->base_price;

        $filename = $request->image['filename'];
        $filepath = $request->image['pathname'];

        $folder = 'multimedia/livrasons/';

        if (!file_exists(public_path($folder))) {
            mkdir(public_path($folder), 777, true);
        }
        $path = $folder .$filename;

        $image = Image::make(file_get_contents($filepath))
            ->resize(320, 453)
            ->save(public_path().'/' .$path );

        $livrason->save();

        if ($livrason) {
            
            $picture = new Images();
            $picture->api_server_path = config('app.url') .'/';
            $picture->folder = $folder;
            $picture->filename = $filename;
            $picture->alt_filename = $filename;
            $picture->livrason_id = $livrason->id;
            $picture->save();
        };

        return sendResponse(new LivrasonResource($livrason), 'Livrason created successfully.');
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        $livrason = Livrason::findOrFail($id);

        if (is_null($livrason)) {

                return sendError(new LivrasonResource($livrason), 'Livrason company not found, status false!');

            }elseif ( $livrason->status == 'activated') {

            return sendResponse(new LivrasonResource($Livrason), 'Livrason company retrieved successfully, status true!');
        }
    }


    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $id = $request->id;
        
        $livrason = Livrason::find($id);

        $livrason->update([
        'company' => $request->company,
        'base_price' => $request->base_price,
        'base_package_type' => $request->base_package_type,
    ]);
        //$id->update($request->all());

        return  sendResponse(new LivrasonResource($livrason), 'Livrason company updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $livrason = Livrason::find($id);
        $livrason->delete($id);
        return  sendResponse([],'Livrason company deleted successfully.');
    }
    /**
     * 
     */
    public function inactive($id)
    {
        DB::table('livrasons')
            ->where('id', $id)
            ->update(['status' => LivrasonStatus::DEACTIVATED]);

        return  sendResponse(new LivrasonResource($id), 'The livrason company is successfully deactivated.');
    }

    /**
     * Update the specified resource in storage.
     */

    public function active($id)
    {
        DB::table('livrasons')
            ->where('id', $id)
            ->update(['status' => LivrasonStatus::ACTIVATED]);

        return  sendResponse(new LivrasonResource($id), 'The livrason company has been successfully activated.');
    }

}
