<?php

namespace Modules\Livrason\app\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\ServiceHelper\app\Http\Resources\ImageResource;

class LivrasonResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'company' => $this->company,
            'company_logo' => ImageResource::collection($this->images), 
            'base_price' => $this->base_price,
            'base_package_type' => $this->base_package_type,
            'basket_price' => $this->basket_price,
            'basket_package_type' => $this->basket_package_type,
            'status' => $this->status,           
            'pivot_price'=> $this->whenPivotLoaded('basket_livrason', function(){
                    return $this->pivot->price;
                }),  
            'pivot_package_type'=> $this->whenPivotLoaded('basket_livrason', function(){
                    return $this->pivot->package_type;
                }),  

            ];
        
    }
}
