<?php

namespace Modules\Livrason\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Livrason\Database\factories\LivrasonFactory;
use Modules\Orders\app\Models\Basket;
use Modules\ServiceHelper\app\Models\Images;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Livrason extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table = 'livrasons';
    
    protected $fillable = [
        'id',
        'company',
        'company_logo',
        'status',
        'basket_sum',
        'baske_package_type'
    ];
    
    public function baskets():BelongsToMany
    {
        return $this->belongsToMany(Basket::class)->withPivot('livrason_id','company','price','package_type');
    }
    public function images(): HasMany
    {
        return $this->hasMany(Images::class);
    }
    
}
