<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\LivrasonStatus;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('livrasons', function (Blueprint $table) {
            $table->id();
            $table->string('company');
            $table->string('company_logo')->nullable();
            $table->decimal('base_price', 8, 2)->default(12.40);
            $table->string('base_package_type')->default('A');
            $table->enum('status', LivrasonStatus::TYPES)->default(LivrasonStatus::DEACTIVATED);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('livrasons');
    }
};
