<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\Livrason\app\Http\Controllers\Api\v1\LivrasonApiController;

/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

Route::middleware(['auth:api','administrator'])->group(function () {
    Route::post('/livrason',[LivrasonApiController::class,'store'])->name('livrason.store');
    Route::put('/livrason/{id}',[LivrasonApiController::class,'update'])->name('livrason.update');
    Route::delete('/livrason/{id}',[LivrasonApiController::class,'destroy'])->name('livrason.destroy');
    Route::put('/livrason/inactive/{id}',[LivrasonApiController::class,'inactive'])->name('livrason.inactive');
    Route::put('/livrason/active/{id}',[LivrasonApiController::class,'active'])->name('livrason.active');
});

// ================= api routes ============== //
    Route::get('/livrason',[LivrasonApiController::class,'index'])->name('livrason.index');
    Route::get('/livrason/{id}',[LivrasonApiController::class,'show'])->name('livrason.show');
    
