<?php

namespace Modules\Messager\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Messager\app\Models\Messager;
use Modules\Messager\app\Http\Resources\MessagerResource;
use Modules\Messager\app\Http\Requests\StoreMessagerRequest;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use Appp\Helpers\GenerateRandomString;
use Illuminate\Support\Facades\DB;
use App\Enums\MessagerStatus;

class MessagerApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): JsonResponse
    {
        $messages = Messager::all();
        return sendResponse(MessagerResource::collection($messages), 'Messages  retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $input = $request->all();

        $data = new Messager();
        $data->client_name = $request->client_name;
        $data->client_email = $request->client_email;
        $data->description = $request->description;
        $data->save();

        return sendResponse(new MessagerResource($data), 'Message  created successfully.');
    }

    /**
     * Show the specified resource.
     */
    public function show($id): JsonResponse
    {
        $message = Messager::findOrFail($id);

        if (is_null($message)) {

                return sendError(new MessagerResource($message), 'Message  not found, status false!');

            }elseif ( $message->status == 'reviewed') {

            return sendResponse(new MessagerResource($message), 'Message  retrieved successfully, status true!');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Messager $id): JsonResponse
    {
        $id->update($request->all());

        return  sendResponse(new MessagerResource($id), 'Message updated successfully.');
    }

    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id): JsonResponse
    {
        $message = Messager::find($id);
        $message->delete($id);
        return  sendResponse([],'Message  deleted successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id): JsonResponse
    {
        DB::table('messagers')
            ->where('id', $id)
            ->update(['status' => MessagerStatus::NOT_REVIEWED]);

        return  sendResponse(new MessagerResource($id), 'The message is successfully deactivated.');
    }

    /**
     * Update the specified resource in storage.
     */

    public function active($id): JsonResponse
    {
        DB::table('messagers')
            ->where('id', $id)
            ->update(['status' => MessagerStatus::REVIEWED]);

        return  sendResponse(new MessagerResource($id), 'The message has been successfully activated.');
    }

}
