<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\Messager\app\Http\Controllers\Api\v1\MessagerApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

// ================ admin routes ======================== ////
Route::post('/message',[MessagerApiController::class,'store'])->name('message.store');
Route::middleware(['auth:api','administrator'])->group(function () {
    Route::get('/message',[MessagerApiController::class,'index'])->name('message.index');
    Route::get('/message/{id}',[MessagerApiController::class,'show'])->name('message.show');
    Route::put('/message/{id}',[MessagerApiController::class,'update'])->name('message.update');
    Route::delete('/message/{id}',[MessagerApiController::class,'destroy'])->name('message.destroy');
    Route::put('/message/inactive/{id}',[MessagerApiController::class,'inactive'])->name('message.inactive');
    Route::put('/message/active/{id}',[MessagerApiController::class,'active'])->name('message.active');
});

// ================= api routes ============== //

Route::middleware(['auth:api'])->group(function () {
    //Route::get('/message',[MessagerApiController::class,'index'])->name('message.index');
    //Route::get('/message/{id}',[MessagerApiController::class,'show'])->name('message.show');
    
});