<?php

namespace Modules\Notification\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Notification\app\Models\Notification;
use Modules\Notification\app\Http\Resources\NotificationResource;
use Modules\Notification\app\Http\Requests\StoreNotificationRequest;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Appp\Helpers\GenerateRandomString;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Modules\Messager\app\Models\Messager;
use App\Enums\NotificationStatus;

class NotificationApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): JsonResponse
    {
        $notifications = Notification::all();
        return sendResponse(NotificationResource::collection($notifications), 'Notifications  retrieved successfully.');
    }
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request): JsonResponse
    {
        $data = new Notification();
        $data->title = $request->title;
        $data->description = $request->description;
        $data->save();
        return sendResponse(new NotificationResource($data), 'Notification created successfully.');
    }
    /**
     * Show the specified resource.
     */
    public function show($id): JsonResponse
    {
        $notification = Notification::findOrFail($id);
        if (is_null($notification)) {
                return sendError(new NotificationResource($notification), 'Notification  not found, status false!');
            }elseif ( $notification->status == 'reviewed') {
            return sendResponse(new NotificationResource($notification), 'Notification  retrieved successfully, status true!');
        }
    }
    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Notification $id): JsonResponse
    {
        $id->update($request->all());
        return  sendResponse(new NotificationResource($id), 'Notification updated successfully.');
    }
    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id): JsonResponse
    {
        $notification = Notification::find($id);
        $notification->delete($id);
        return  sendResponse([],'Notification  deleted successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id): JsonResponse
    {
        DB::table('notifications')
            ->where('id', $id)
            ->update(['status' => NotificationStatus::NOT_REVIEWED]);
        return  sendResponse(new NotificationResource($id), 'The notification is successfully deactivated.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function active($id): JsonResponse
    {
        DB::table('notifications')
            ->where('id', $id)
            ->update(['status' => NotificationStatus::REVIEWED]);
        return  sendResponse(new NotificationResource($id), 'The notification has been successfully activated.');
    }
}
