<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\Notification\app\Http\Controllers\Api\v1\NotificationApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

// ================ admin routes ======================== //

Route::middleware(['auth:api','administrator'])->group(function () {
    Route::get('/notification',[NotificationApiController::class,'index'])->name('notification.index');
    Route::get('/notification/{id}',[NotificationApiController::class,'show'])->name('notification.show');
    Route::post('/notification',[NotificationApiController::class,'store'])->name('notification.store');
    Route::put('/notification/{id}',[NotificationApiController::class,'update'])->name('notification.update');
    Route::delete('/notification/{id}',[NotificationApiController::class,'destroy'])->name('notification.destroy');
    Route::put('/notification/inactive/{id}',[NotificationApiController::class,'inactive'])->name('notification.inactive');
    Route::put('/notification/active/{id}',[NotificationApiController::class,'active'])->name('notification.active');
});