<?php

namespace Modules\Orders\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Appp\Helpers\ResponseHelper;
use Modules\Orders\app\Http\Resources\BasketResource;
use Modules\Orders\app\Http\Resources\BasketProductResource;
use Modules\Orders\app\Models\Basket;
use Modules\Products\app\Http\Resources\ProductResource;
use Modules\Products\app\Models\Product;
use Modules\ServiceHelper\app\Models\Discont;
use Modules\Livrason\app\Models\Livrason;
use Modules\Livrason\app\Models\Shipment;
use Modules\Livrason\app\Models\DPD;
use Modules\Livrason\app\Models\inPost;
use Modules\Livrason\app\Models\Paczkomat;

class BasketApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $baskets = Basket::all();
    
        return sendResponse(BasketResource::collection($baskets), 'Baskets retrieved successfully.');
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        $basket = Basket::findOrFail($id);
        
        if (is_null($basket)) {

                return sendError(new BasketResource($basket), 'Basket not found, status false!');

            }else {

            return sendResponse(new BasketResource($basket),'Basket products retrieved successfully, status true!');
        }
    }
    /**
     * 
     */
    public function addProduct(Request $request) 
    {
        $id = $request->basket_id;
        $product_id = $request->product_id;       
        $count = 1;
        $product = Product::find($product_id);

        if (empty($id)) {
        /***
         * створюєм корзину ;
         *  розраховуєм вартість доставки 
         */
        $inPost = Livrason::find(1);
        $paczkomat = Livrason::find(2);
        $dpd = Livrason::find(3);   

        foreach($product->disconts as $discont){

            $discont_value = ($product->price / 100) * $discont->value;
            $total_product_price_with_discont = $product->price - $discont_value;
            $total_product_price_with_discont_end_delivery = 0.00;//загальна вартість товару зі знижкою та доставкою
            $total_weight = $product->weight;//визначаєм загальну вагу посилки

            $basket = Basket::create([
                'quantity' => 1,
                'total_price' => $product->price,
                'count' => $count,
                'total_product_price_with_discont' => $total_product_price_with_discont,
                'total_product_price_with_discont_end_delivery' => $total_product_price_with_discont_end_delivery,
                'currency' => $product->currency->alias,
                'total_discont'=> $discont->value,
                'total_weight' => $total_weight,
            ]);
            /**
             * тут розраховуєм вартість доставки
            */
            if ($total_weight <= 1000) { 

            $delivery_inpost = $basket->livrasons()->attach($inPost,[
                'company' => $inPost->company,
                'price' => $inPost->base_price,
                'package_type' => $inPost->base_package_type
            ]);

            $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,[
                'company' => $paczkomat->company,
                'price' => $paczkomat->base_price,
                'package_type' => $paczkomat->base_package_type
            ]);
            
            $delivery_dpd = $basket->livrasons()->attach($dpd,[
                'company' => $dpd->company,
                'price' => $dpd->base_price,
                'package_type' => $dpd->base_package_type
            ]);

            }elseif ($total_weight >= 1000 && $total_weight <= 5000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,[
                    'company' => $inPost->company,
                    'price' => $inPost->base_price,
                    'package_type' => $inPost->base_package_type
                ]);

                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,[
                    'company' => $paczkomat->company,
                    'price' => $paczkomat->base_price,
                    'package_type' => $paczkomat->base_package_type
                ]);

                $delivery_dpd = $basket->livrasons()->detach($dpd,[
                    'company' => $dpd->company,
                    'price' => $dpd->base_price,
                    'package_type' => $dpd->base_package_type
                ]);

                $delivery_inpost = $basket->livrasons()->attach($inPost,[
                'company' => $inPost->company,
                'price' => $inPost->base_price + 4,
                'package_type' => 'B'
                ]);

                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,[
                'company' => $paczkomat->company,
                'price' => $paczkomat->base_price + 4,
                'package_type' => 'B'
                ]);

                $delivery_dpd = $basket->livrasons()->attach($dpd,[
                'company' => $dpd->company,
                'price' => $dpd->base_price + 4,
                'package_type' => 'B'
                ]);

            }elseif ($total_weight >= 5000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,[
                    'company' => $inPost->company,
                    'price' => $inPost->base_price,
                    'package_type' => $inPost->base_package_type
                ]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,[
                    'company' => $paczkomat->company,
                    'price' => $paczkomat->base_price,
                    'package_type' => $paczkomat->base_package_type
                ]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,[
                    'company' => $dpd->company,
                    'price' => $dpd->base_price,
                    'package_type' => $dpd->base_package_type
                ]);           
                $delivery_inpost = $basket->livrasons()->attach($inPost,[
                    'company' => $inPost->company,
                    'price' => $inPost->base_price + 8,
                    'package_type' => 'C'
                ]);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,[
                    'company' => $paczkomat->company,
                    'price' => $paczkomat->base_price + 8,
                    'package_type' => 'C'
                ]);
                $delivery_dpd = $basket->livrasons()->attach($dpd,[
                    'company' => $dpd->company,
                    'price' => $dpd->base_price + 8,
                    'package_type' => 'C'
                ]);

            }else {

                    return;
            }

            $basket->products()->attach($product_id,[

                'quantity' => 1,
                'price' => $product->price,
                'price_with_discont' => $total_product_price_with_discont,
                'product_discont' => $discont->value,
                'product_weight' => $product->weight,
                
            ]);
        
    }
            return sendResponse(new BasketResource($basket),'Basket created successfully.');
            
        } else {

            $inPost = Livrason::find(1);
            $paczkomat = Livrason::find(2);
            $dpd = Livrason::find(3);

            $basket = Basket::findOrFail($id);
            /**
             * калькулятор розрахунку вартості продукту зі знижкою
             */
            foreach($product->disconts as $discont){

            $discont_value = ($product->price / 100) * $discont->value;

            $product_price_with_discont = $product->price - $discont_value;
            
            /**
             * отримане значення ціни зі знижкою та значення знижки продукта вставляєсм в pivot таблицю
             */

            $basket->products()->attach($product_id,[
                'quantity' => 1,
                'price' => $product->price,
                'price_with_discont' => $product_price_with_discont,
                'product_discont' => $discont->value,
                'product_weight' => $product->weight,
            ]);

            }
            /**
             * виводимо загальну ціну та загальну знижку на продукти
             */

            $total_price = $basket->products->sum('pivot.price');//загальна сума товарів в кількості 1

            $total_pivot_discont = $basket->products->sum('pivot.product_discont');//загальна сума знижок

            $total_quantity = $basket->products->sum('pivot.quantity');

            $total_product_price_with_discont = $basket->products->sum('pivot.price_with_discont');//загальна сума вартісті продуктів зі знижкою в кількості 1

            $total_product_price_with_discont_end_delivery = 0.00;//загальна сума вартісті продуктів зі знижкою та доставкою в кількості 1
            /**
             * калькулятор розрахунку загальної знижки
             * визначення загальної знижки це:сума знижок всіх продуктів / на суму кількісті  продуктів
             * $total_discont = $total_pivot_discont / $total_quantity;
             */
            $total_discont = $total_pivot_discont / $total_quantity;
            
            $total_products_quantity = $basket->products->count();//загальна кількість продуктів в корзині

            $discont_price = $total_price - $total_product_price_with_discont;//знижка

            $total_weight = $basket->products->sum('pivot.product_weight');//загальна вага продуктів в корзині
            /**
             * тут розраховуєм вартість доставки по вазі товару
            */
            if ($total_weight <= 1000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,[
                    'company' => $inPost->company,
                    'price' => $inPost->base_price,
                    'package_type' => $inPost->base_package_type
                ]);

                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,[
                    'company' => $paczkomat->company,
                    'price' => $paczkomat->base_price,
                    'package_type' => $paczkomat->base_package_type
                ]);

                $delivery_dpd = $basket->livrasons()->detach($dpd,[
                    'company' => $dpd->company,
                    'price' => $dpd->base_price,
                    'package_type' => $dpd->base_package_type
                ]);
            
                $delivery_inpost = $basket->livrasons()->attach($inPost,[
                    'company' => $inPost->company,
                    'price' => $inPost->base_price,
                    'package_type' => $inPost->base_package_type
                ]);

                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,[
                    'company' => $paczkomat->company,
                    'price' => $paczkomat->base_price,
                    'package_type' => $paczkomat->base_package_type
                ]);

                $delivery_dpd = $basket->livrasons()->attach($dpd,[
                    'company' => $dpd->company,
                    'price' => $dpd->base_price,
                    'package_type' => $dpd->base_package_type
                ]);
    
                }elseif ($total_weight >= 1000 && $total_weight <= 5000) {

                    $delivery_inpost = $basket->livrasons()->detach($inPost,[
                        'company' => $inPost->company,
                        'price' => $inPost->base_price,
                        'package_type' => $inPost->base_package_type
                    ]);

                    $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,[
                        'company' => $paczkomat->company,
                        'price' => $paczkomat->base_price,
                        'package_type' => $paczkomat->base_package_type
                    ]);

                    $delivery_dpd = $basket->livrasons()->detach($dpd,[
                        'company' => $dpd->company,
                        'price' => $dpd->base_price,
                        'package_type' => $dpd->base_package_type
                    ]);
    
                $delivery_inpost = $basket->livrasons()->attach($inPost,[
                    'company' => $inPost->company,
                    'price' => $inPost->base_price + 4,
                    'package_type' => 'B'
                ]);

                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,[
                    'company' => $paczkomat->company,
                    'price' => $paczkomat->base_price + 4,
                    'package_type' => 'B'
                ]);

                $delivery_dpd = $basket->livrasons()->attach($dpd,[
                    'company' => $dpd->company,
                    'price' => $dpd->base_price + 4,
                    'package_type' => 'B'
                ]);
    
                }elseif ($total_weight >= 5000) {

                    $delivery_inpost = $basket->livrasons()->detach($inPost,[
                        'company' => $inPost->company,
                        'price' => $inPost->base_price,
                        'package_type' => $inPost->base_package_type
                    ]);

                    $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,[
                        'company' => $paczkomat->company,
                        'price' => $paczkomat->base_price,
                        'package_type' => $paczkomat->base_package_type
                    ]);

                    $delivery_dpd = $basket->livrasons()->detach($dpd,[
                        'company' => $dpd->company,
                        'price' => $dpd->base_price,
                        'package_type' => $dpd->base_package_type
                    ]);
                
                $delivery_inpost = $basket->livrasons()->attach($inPost,[
                    'company' => $inPost->company,
                    'price' => $inPost->base_price + 8,
                    'package_type' => 'C'
                ]);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,[
                    'company' => $paczkomat->company,
                    'price' => $paczkomat->base_price + 8,
                    'package_type' => 'C'
                ]);
                $delivery_dpd = $basket->livrasons()->attach($dpd,[
                    'company' => $dpd->company,
                    'price' => $dpd->base_price + 8,
                    'package_type' => 'C'
                ]);
    
                }else {
                return;
                }
            /**
             * обновлюєм модель корзини з новими значеннями
             */
                if($basket){   
                    $basket->total_price = $total_price;
                    $basket->total_product_price_with_discont = $total_product_price_with_discont;
                    $basket->total_product_price_with_discont_end_delivery = $total_product_price_with_discont_end_delivery;
                    $basket->total_discont = $discont_price;
                    $basket->total_weight = $total_weight;
                    $basket->quantity = $total_quantity;
                    $basket->count = $total_products_quantity;
                    $basket->currency = $product->currency->alias;
                    $basket->update();
                
            return sendResponse(new BasketResource($basket),'Basket created successfully.');
        }
    }
}
    /**
     * 
     */

    public function updateQuantityPlus(Request $request) 
    {
        $id = $request->basket_id;

        $product_id = $request->product_id;

        $quantity = $request->quantity;

        $price = $request->price; 

        $inPost = Livrason::find(1);
        $paczkomat = Livrason::find(2);
        $dpd = Livrason::find(3);

        $prod = Product::find($product_id);

            $product_weight = $prod->weight;

            $basket = Basket::findOrFail($id);

            $product = $basket->products()->where('product_id',$product_id)->first()->pivot;

            $newQuantity = $product->quantity + $quantity;

            $newPrice = $price * $newQuantity;

            $weight = $product_weight + $product->product_weight;

            $newPriceWithDiscont = $product->price_with_discont * $newQuantity;

            $product->update(['quantity' => $newQuantity,'price' => $newPrice,'price_with_discont' => $newPriceWithDiscont,'product_weight' => $weight]);
            
            $total_price = $basket->products->sum('pivot.price');

            $total_pivot_discont = $basket->products->sum('pivot.product_discont');

            $total_quantity = $basket->products->sum('pivot.quantity');

            $total_product_price_with_discont = $basket->products->sum('pivot.price_with_discont');

            $basket->quantity = $newQuantity;

            $total_weight = $basket->products->sum('pivot.product_weight');

            $total_products_quantity = $basket->products->count();

            $discont_price = $total_price - $total_product_price_with_discont;
            /**
             * тут розраховуєм вартість доставки
            */
            if ($total_weight <= 1000) {
                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
            
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
    
                }elseif ($total_weight >= 1000 && $total_weight <= 5000) {
                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->package_type]);
    
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price + 4,'package_type' => 'B']);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price + 4,'package_type' => 'B']);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price + 4,'package_type' => 'B']);
    
                }elseif ($total_weight >= 5000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
                
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price + 8,'package_type' => 'C']);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price + 8,'package_type' => 'C']);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price + 8,'package_type' => 'C']);
    
                }else {

                return;
                }
            /**
            * update model Basket
            */
            $basket->total_price = $total_price;

            $basket->total_product_price_with_discont =  $total_product_price_with_discont ;

            $basket->total_discont = $discont_price;

            $basket->quantity = $total_quantity;

            $basket->count = $total_products_quantity;
            
            $basket->total_weight = $total_weight;
        
            $basket->update();

            return sendResponse($product->weight,'Basket created successfully.');
    }

    /**
     * 
     */

    public function updateQuantityMinus(Request $request) 
    {
        $id = $request->basket_id;

        $product_id = $request->product_id;

        $quantity = $request->quantity;

        $price = $request->price;  

        $inPost = Livrason::find(1);

        $paczkomat = Livrason::find(2);

        $dpd = Livrason::find(3);
            
            $prod = Product::find($product_id);

            $product_weight = $prod->weight;

            $basket = Basket::findOrFail($id);

            $product = $basket->products()->where('product_id',$product_id)->first()->pivot;

            $newQuantity = $product->quantity - $quantity;

            $newPrice = $product->price - $price;

            if ($newQuantity >= 1){

            $newDiscont = ($newPrice / 100) * $product->product_discont;

            $newPriceWithDiscont = $newPrice - $newDiscont * $newQuantity;

            $weight = $product->product_weight - $product_weight;

            $product->update(['quantity' => $newQuantity,'price' => $newPrice,'price_with_discont' => $newPriceWithDiscont,'product_weight' => $weight]);

            $total_price = $basket->products->sum('pivot.price');

            $total_pivot_discont = $basket->products->sum('pivot.product_discont');

            $total_quantity = $basket->products->sum('pivot.quantity');

            $total_product_price_with_discont = $basket->products->sum('pivot.price_with_discont');

            $basket->quantity = $newQuantity;

            $total_weight = $basket->products->sum('pivot.product_weight');

            $total_products_quantity = $basket->products->count();

            $discont_price = $total_price - $total_product_price_with_discont;
            /**
             * тут розраховуєм вартість доставки
            */
            if ($total_weight >= 1000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
            
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
    
                }elseif ($total_weight >= 1000 && $total_weight <= 5000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
    
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price + 4,'package_type' => 'B']);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price + 4,'package_type' => 'B']);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price + 4,'package_type' => 'B']);
    
                }elseif ($total_weight >= 5000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
                
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price + 8,'package_type' => 'C']);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price + 8,'package_type' => 'C']);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price + 8,'package_type' => 'C']);
    
                }else {

                return;
                }
            /**
            * update model Basket
            */
            $basket->total_price = $total_price;

            $basket->total_product_price_with_discont =  $total_product_price_with_discont ;

            $basket->total_discont = $discont_price;

            $basket->quantity = $total_quantity;

            $basket->count = $total_products_quantity;

            $basket->total_weight = $total_weight;

            $basket->update();

            }else{

            $product->update(['quantity' => 1,'price' => $price,'price_with_discont' => $product->price_with_discont,'product_weight' => $product_weight]);

            $total_price = $basket->products->sum('pivot.price');

            $total_pivot_discont = $basket->products->sum('pivot.product_discont');

            $total_quantity = $basket->products->sum('pivot.quantity');

            $total_product_price_with_discont = $basket->products->sum('pivot.price_with_discont');

            $total_weight = $basket->products->sum('pivot.product_weight');

            $discont_price = $total_price - $total_product_price_with_discont;

            $basket->quantity = $newQuantity;

            $total_products_quantity = $basket->products->count();
            /**
             * тут розраховуєм вартість доставки
            */
            if ($total_weight >= 1000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
            
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
    
                }elseif ($total_weight >= 1000 && $total_weight <= 5000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
    
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price + 4,'package_type' => 'B']);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price + 4,'package_type' => 'B']);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price + 4,'package_type' => 'B']);
    
                }elseif ($total_weight >= 5000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
                
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price + 8,'package_type' => 'C']);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price + 8,'package_type' => 'C']);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price + 8,'package_type' => 'C']);
    
                }else {

                return;
                }
            /**
            * update model Basket
            */
            $basket->total_price = $total_price;

            $basket->total_product_price_with_discont =  $total_product_price_with_discont ;

            $basket->total_discont = $discont_price;

            $basket->quantity = $total_quantity;

            $basket->count = $total_products_quantity;

            $basket->total_weight = $total_weight;

            $basket->update();
            }
            return sendResponse(new BasketResource($basket),'Basket created successfully.');
    }
    /**
     * видалення продукту з корзини
     */
    public function removeProduct(Request $request)
    {
        $id = $request->basket_id;

        $product_id = $request->product_id;

        $inPost = Livrason::find(1);

        $paczkomat = Livrason::find(2);

        $dpd = Livrason::find(3);

        $basket = Basket::findOrFail($id);

        $product = $basket->products()->detach($product_id);

        $total_price = $basket->products->sum('pivot.price');

        $total_pivot_discont = $basket->products->sum('pivot.product_discont');

        $total_quantity = $basket->products->sum('pivot.quantity');

        $total_product_price_with_discont = $basket->products->sum('pivot.price_with_discont');

        $total_weight = $basket->products->sum('pivot.product_weight');

        $discont_price = $total_price - $total_product_price_with_discont;
        /**
        * тут розраховуєм вартість доставки
        */
            if ($total_weight >= 1000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
            
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
    
                }elseif ($total_weight >= 1000 && $total_weight <= 5000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
    
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price + 4,'package_type' => 'B']);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price + 4,'package_type' => 'B']);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price + 4,'package_type' => 'B']);
    
                }elseif ($total_weight >= 5000) {

                $delivery_inpost = $basket->livrasons()->detach($inPost,['company' => $inPost->company,'price' => $inPost->base_price,'package_type' => $inPost->base_package_type]);
                $delivery_paczkomat = $basket->livrasons()->detach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price,'package_type' => $paczkomat->base_package_type]);
                $delivery_dpd = $basket->livrasons()->detach($dpd,['company' => $dpd->company,'price' => $dpd->base_price,'package_type' => $dpd->base_package_type]);
                
                $delivery_inpost = $basket->livrasons()->attach($inPost,['company' => $inPost->company,'price' => $inPost->base_price + 8,'package_type' => 'C']);
                $delivery_paczkomat = $basket->livrasons()->attach($paczkomat,['company' => $paczkomat->company,'price' => $paczkomat->base_price + 8,'package_type' => 'C']);
                $delivery_dpd = $basket->livrasons()->attach($dpd,['company' => $dpd->company,'price' => $dpd->base_price + 8,'package_type' => 'C']);
    
                }else {

                return;

                }
        /**
         * update model Basket
         */
        $basket->total_price = $total_price;

        $basket->total_product_price_with_discont = $total_product_price_with_discont ;

        $basket->total_discont = $discont_price;

        $basket->quantity = $total_quantity;

        $basket->count = $basket->products->count();

        $basket->total_weight = $total_weight;

        $basket->update();

        return sendResponse(new BasketResource($basket),'Product delete for basket successfully.');
    }
    /**
     * 
     */
    public function updateDeliveryPrice(Request $request)
    {
        $id = $request->basket_id;

        $basket = Basket::findOrFail($id);

        $livrason_id = $request->livrason_id;

        $livrason_price = $request->livrason_price;

        $total_product_price_with_discont = $basket->products->sum('pivot.price_with_discont');
        
        $total_product_price_with_discont_end_delivery = $total_product_price_with_discont + $livrason_price;

            
            $basket->livrason_id = $livrason_id;
            $basket->livrason_price = $livrason_price;
            $basket->total_product_price_with_discont_end_delivery = $total_product_price_with_discont_end_delivery;
            $basket->update();

            return sendResponse(new BasketResource($basket),'The basket delivery update successfully.');

    }
}
