<?php

namespace Modules\Orders\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Http;
use App\Models\User;
use Modules\Orders\app\Models\Order;
use Modules\Orders\app\Models\OrderPayment;
use Modules\Delivery\app\Models\Delivery;
use Appp\Helpers\ResponseHelper;
use Modules\Orders\app\Http\Resources\OrderResource;
use Modules\Orders\app\Http\Resources\OrderPaymentResource;
use App\Helpers\GenerateRandomString;
use Modules\Orders\app\Models\Basket;
use Modules\Payments\app\Models\PaymentGateway;
use App\Enums\OrderStatus;
use App\Enums\DeliveryStatus;
use App\Enums\PaymentStatus;
use App\Enums\ReglamentStatus;
use App\Enums\LoyaltyStatus;
use App\Services\Signature;
use Illuminate\Support\Facades\Session;
use Modules\Notification\app\Models\Notification;
use Illuminate\Support\Facades\Redirect;
class OrdersApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {   
        $orders = Order::all();
        return sendResponse(OrderResource($orders),'Order required successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {   
        $auth = $request->auth;

        $basket_id = $request->basket_id;

        $livrason_id = $request->livrason_id;

        $basket = Basket::findOrFail($basket_id);

        $livrason = $basket->livrasons()->where('livrason_id',$livrason_id)->first()->pivot;
        //request payment variables       
        $paymentGatewayId = $request->payment_gateway_id;

        $reglament =  $request->reglament;
        $loyalty =  $request->loyalty;
        /**
         * 
         */
        if (is_null($auth)) {

            $user = User::create([
                'name' => $request->name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'phone' => $request->phone,
                'password' => generateRandomString(8),
            ]);

            $user->save();

        }else{

            $id = $auth['data']['id'];
            $user = User::findOrFail($id);
            $user->last_name = $request->last_name;
            $user->phone = $request->phone;
            $user->update();
        }
        /**
         * 
         */
            $shipment = new Delivery();
            $shipment->client_last_name = $user->last_name;
            $shipment->client_first_name = $user->name;
            $shipment->client_email = $user->email;
            $shipment->client_phone = $user->phone;
            $shipment->client_country = $request->country;
            $shipment->client_city = $request->city;
            $shipment->client_street = $request->street;
            $shipment->client_zip_code = $request->zip_code;
            $shipment->company = $livrason->company;
            $shipment->sum = $livrason->price;
            $shipment->package_type = $livrason->package_type;
            $shipment->save();
        /**
         * отримуєм дані платіжного шлюзу
         */
        $payment_gateway = PaymentGateway::findOrFail($paymentGatewayId);
        /**
         * зберігаєм замовлення
         */
        $order = new Order();
        $order->basket_id = $basket_id;
        $order->user_id = $user->id;
        $order->delivery_id = $shipment->id;
        $order->amount = $request->basket_price;
        $order->currency = $request->basket_currency;
        /**
         * Order status variables
         */
        if ($reglament = '1') {
            $order->reglament =  ReglamentStatus::READ;
        }else {
            $order->reglament =  ReglamentStatus::NOT_READ;
        }       
        if ($loyalty = '1') {
            $order->loyalty =  LoyaltyStatus::PARTNERSHIP;
        }else {
            $order->loyalty =  LoyaltyStatus::NOT_PARTNERSHIP;
        }
        $order->status = OrderStatus::IN_PROGRESS;
        $order->delivery_status = DeliveryStatus::IN_PROGRESS;
        $order->payment_status = PaymentStatus::IN_PROGRESS;
        $order->save();
        /**
         * зберігаєм дані для платіжного шлюзу
         */
        if ($order) {
            /**
             * 
             */
            $notify = new Notification();
            $notify->reference = generateRandomString(8);
            $notify->model_id = $order->id;
            $notify->model_name = 'product';
            $notify->message = 'You have a new order:';
            $notify->save();
            /**
             * створюєм підпис для трансакції оплати
             */
            $sessionId = session()->getId();

            $sign = Signature::createSignature([
                'sessionId' => $sessionId,
                'merchantId' => 279197,
                'amount' => 2500,
                'currency' => 'PLN',
                'crc' => '035416b9b7b36744',
            ]);

            $response = Http::withHeaders([

                'Accept' => 'application/json',
                'Content-Type' => 'application/json',
    
            ])->withBasicAuth('279197', 'fef9e5efa8c5865975f3d057ba13a9d3')->post("https://sandbox.przelewy24.pl/api/v1/transaction/register",[
                'merchantId' => 279197,
                'posId' => 279197,
                'sessionId' => $sessionId,
                'amount' => 2500,
                'currency' => 'PLN',
                'description' => 'test for card payment',
                'email' => 'admin@admin.com',
                'country' => 'PL',
                'language' => 'pl',
                'method' => 0,
                'urlReturn' => 'http://boutique-client.eu',
                'urlStatus' => 'http://boutique-client.eu',
                'channel' => 8,
                'waitForResult' => true,
                'regulationAccept' => true,
                'sign' => $sign,
                ]);                             

            $result = json_decode($response -> getBody()->getContents());

            $orderPayment = new OrderPayment();
            $orderPayment->order_id = $order->id;
            $orderPayment->amount = $order->amount;
            $orderPayment->currency = $order->currency;
            $orderPayment->token = $result->data->token;
            $orderPayment->payment_gateway_name = $payment_gateway->paymentGatewayName;
            $orderPayment->save();
        
            return sendResponse(new OrderPaymentResource($orderPayment),'Order created successfully.');

        }else {

            return sendResponse(new OrderPaymentResource($orderPayment),'Order created successfully.');
        }
        
    }
    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        return ;
    }


    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id): RedirectResponse
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
    }
}
