<?php

namespace Modules\Orders\app\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Products\app\Http\Resources\ProductResource;
use Modules\Livrason\app\Http\Resources\LivrasonResource;

class BasketResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request): array
    {
        return [
            'id'=>$this->id,
            'quantity' =>$this->quantity,
            'total_price' => $this->total_price,
            'total_product_price_with_discont' => $this->total_product_price_with_discont,
            'total_product_price_with_discont_end_delivery' => $this->total_product_price_with_discont_end_delivery,
            'count' =>$this->count,
            'currency' =>$this->currency,
            'total_discont' => $this->total_discont,
            'total_weight' => $this->total_weight,
            'livrason_id' => $this->livrason_id,
            'livrason_price' =>$this->livrason_price,
            'products' =>  ProductResource::collection($this->products),
            'livrasons' => LivrasonResource::collection($this->livrasons),
        ];
    }
}
