<?php

namespace Modules\Orders\app\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Orders\app\Http\Resources\BasketResource;
use App\Http\Resources\UserResource;
use Modules\Delivery\app\Http\Resources\DeliveryResource;
use Modules\Livrason\app\Http\Resources\LivrasonResource;
class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'basket' => new BasketResource($this->basket),
            'user' => new UserResource($this->user),
            'delivery' => new DeliveryResource($this->delivery),
            'payment_gateway_id' => $this->payment_gateway_id,
            'amount' => $this->amount,
            'currency' => $this->currency,
            'reglament' => $this->reglament,
            'loyalty' => $this->loyalty,
            'status' =>$this->status,
            'delivery_status' =>$this->delivery_status,
            'payment_status' =>$this->payment_status,
        ];
    }
}
