<?php

namespace Modules\Orders\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Orders\Database\factories\BasketFactory;
use Modules\Products\app\Models\Product;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Orders\app\Models\Order;
use Modules\Livrason\app\Models\Livrason;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Basket extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table = "baskets";

    protected $fillable = [
        'id',
        'quantity',
        'count',
        'currency',
        'total_price',
        'total_product_price_with_discont',
        'total_product_price_with_discont_end_delivery',
        'total_discont',
        'total_weight',
        'livrason_id',
        'livrasone_price',
        'product',
        'order_id',
        
    ];
    
    public function products(): BelongsToMany
    {
        return $this->belongsToMany(Product::class)->withPivot('quantity','price','price_with_discont','product_discont','product_weight');
    }
    public function livrasons(): BelongsToMany
    {
        return $this->belongsToMany(Livrason::class)->withPivot('livrason_id','company','price','package_type');
    }

    public function orders(): HasMany
    {
        return $this->hasMany(Order::class);
    }
    
}
