<?php

namespace Modules\Orders\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Orders\Database\factories\OrderFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User;
use Modules\Orders\app\Models\Basket;
use Modules\Delivery\app\Models\Delivery;

class Order extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table = 'orders';
    
    protected $fillable = [
        'id',
        'basket_id',
        'user_id',
        'delivery_id',
        'payment_gateway_id',
        'amount',
        'currency',
        'reglament',
        'loyalty',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function basket():BelongsTo
    {
        return $this->belongsTo(Basket::class);
    }
    
    public function delivery():BelongsTo
    {
        return $this->belongsTo(Delivery::class);
    }
}
