<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('baskets', function (Blueprint $table) {
            $table->id();
            $table->string('quantity')->nullable();
            $table->decimal('total_price', 8, 2)->default(0.00);
            $table->decimal('total_product_price_with_discont', 8, 2)->default(0.00);
            $table->decimal('total_product_price_with_discont_end_delivery', 8, 2)->default(0.00);
            $table->float('total_discont')->default(0.00);
            $table->float('total_weight')->default(0.00);
            $table->bigInteger('count')->default(0);
            $table->string('currency');
            $table->bigInteger('livrason_id')->nullable();
            $table->float('livrason_price')->nullable();
            $table->string('livrason_package_type')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('baskets');
    }
};
