<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\OrderStatus;
use App\Enums\DeliveryStatus;
use App\Enums\PaymentStatus;
use App\Enums\ReglamentStatus;
use App\Enums\LoyaltyStatus;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('basket_id')->nullable()->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->nullable()->constrained()->cascadeOnDelete();
            $table->foreignId('delivery_id')->nullable()->constrained()->cascadeOnDelete();
            $table->integer('payment_gateway_id')->nullable();
            $table->decimal('amount', 8, 2)->default(0.00);
            $table->string('currency');
            $table->enum('reglament', ReglamentStatus::TYPES)->default(ReglamentStatus::NOT_READ);
            $table->enum('loyalty', LoyaltyStatus::TYPES)->default(LoyaltyStatus::NOT_PARTNERSHIP);
            $table->enum('status', OrderStatus::TYPES)->default(OrderStatus::IN_PROGRESS);
            $table->enum('payment_status', PaymentStatus::TYPES)->default(PaymentStatus::IN_PROGRESS);
            $table->enum('delivery_status', DeliveryStatus::TYPES)->default(DeliveryStatus::IN_PROGRESS);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
