<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('basket_livrason', function (Blueprint $table) {
            $table->id();
            $table->foreignId('basket_id')->nullable()->constrained()->cascadeOnDelete();
            $table->foreignId('livrason_id')->nullable()->constrained()->cascadeOnDelete();
            $table->string('company');
            $table->decimal('price', 8, 2);
            $table->string('package_type');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('basket_livrason');
    }
};
