<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\Orders\app\Http\Controllers\Api\v1\BasketApiController;
use \Modules\Orders\app\Http\Controllers\Api\v1\OrdersApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

    Route::get('/basket',[BasketApiController::class,'index'])->name('basket.index');
    Route::get('/basket/{id}',[BasketApiController::class,'show'])->name('basket.show');
    Route::post('/basket/addProduct',[BasketApiController::class,'addProduct'])->name('basket.addProduct');
    Route::post('/basket/removeProduct',[BasketApiController::class,'removeProduct'])->name('basket.removeProduct');
    Route::post('/basket/updateQuantityPlus',[BasketApiController::class,'updateQuantityPlus'])->name('basket.updateQuantityPlus');
    Route::post('/basket/updateQuantityMinus',[BasketApiController::class,'updateQuantityMinus'])->name('basket.updateQuantityMinus');
    Route::post('/basket/updateDeliveryPrice',[BasketApiController::class,'updateDeliveryPrice'])->name('basket.updateDeliveryPrice');

    Route::get('/order',[OrdersApiController::class,'index'])->name('order.index');
    Route::get('/order/{id}',[OrdersApiController::class,'show'])->name('order.show');
    Route::post('/order',[OrdersApiController::class,'store'])->name('order.store');
    Route::put('/order/{id}',[OrdersApiController::class,'update'])->name('order.update');
    Route::delete('/order/{id}',[OrdersApiController::class,'destroy'])->name('order.destroy');



