<?php

namespace Modules\Payments\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Intervention\Image\Facades\Image as Image;
use Modules\ServiceHelper\app\Models\Images;
use Modules\Messager\app\Models\Messager;
use Modules\Payments\app\Models\PaymentGateway;
use Modules\Payments\app\Http\Resources\PaymentGatewayResource;
use App\Enums\PaymentGatewayStatus;

class PaymentGatewayApiController extends Controller
{
    

    /**
     * Display a listing of the resource.
    */

    public function index()
    {
        $paymentGateways = PaymentGateway::all();
       

        return sendResponse(new PaymentGatewayResource($paymentGateways), 'Payment gateways retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
    */

    public function store(Request $request)
    {
        
        $paymentGateway = new PaymentGateway();
        $paymentGateway->paymentGatewayName = $request->paymentGatewayName;       
        $paymentGateway->status = PaymentGatewayStatus::DEACTIVATED;
        
        $filename = $request->image['filename'];
        $filepath = $request->image['pathname'];

        $folder = 'multimedia/payment_gateways/';

        if (!file_exists(public_path($folder))) {
            mkdir(public_path($folder), 777, true);
        }
        $path = $folder .$filename;

        $image = Image::make(file_get_contents($filepath))
            ->save(public_path().'/' .$path );

        $paymentGateway->save();
        if ($paymentGateway) {
            
            $picture = new Images();
            $picture->api_server_path = config('app.url') .'/';
            $picture->folder = $folder;
            $picture->filename = $filename;
            $picture->alt_filename = $filename;
            $picture->payment_gateway_id = $paymentGateway->id;
            $picture->save();
        };
        return sendResponse(new PaymentGatewayResource($paymentGateway), 'Payment gateway created successfully.');
    }

    /**
     * Show the specified resource.
    */
    
    public function show($id)
    {
        $paymentGateway = PaymentGateway::findOrFail($id);

        if (is_null($paymentGateway)) {

                return sendError(new PaymentGatewayResource($paymentGateway), 'Payment gateway not found, status false!');

            }elseif ( $paymentGateway->status == 'activated') {

            return sendResponse(new PaymentGatewayResource($paymentGateway), 'Payment gateway retrieved successfully, status true!');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PaymentGateway $id)
    {
        $id->update($request->all());

        return  sendResponse(new PaymentGatewayResource($id), 'Payment gateway updated successfully.');
    }

    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        $paymentGateway = PaymentGateway::find($id);

        $paymentGateway->delete($id);

        return  sendResponse([],'Payment gateway deleted successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id)
    {
        DB::table('payment_gateways')
            ->where('id', $id)
            ->update(['status' => PaymentGatewayStatus::DEACTIVATED]);

        return  sendResponse(new PaymentGatewayResource($id), 'The payment gateway is successfully deactivated.');
    }

    /**
     * Update the specified resource in storage.
     */

    public function active($id)
    {
        DB::table('payment_gateways')
            ->where('id', $id)
            ->update(['status' => PaymentGatewayStatus::ACTIVATED]);

        return  sendResponse(new PaymentGatewayResource($id), 'The payment gateway has been successfully activated.');
    }

    /**
     * Display a listing of actived status the resource.
     */
    
    public function getPymentGatewayWithActivedStatus()
    {
        $paymentGateways = PaymentGateway::where('status','=','activated')->get();
    
        return sendResponse(PaymentGatewayResource::collection($paymentGateways), 'Payment gateways actived resources successfully.');
    }
}
