<?php

namespace Modules\Payments\app\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\ServiceHelper\app\Http\Resources\ImageResource;

class PaymentGatewayResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'paymentGatewayName' => $this->paymentGatewayName,
            'image' =>  ImageResource::collection($this->images), 
            'status' => $this->status,
            'merchantId' => $this->merchantId,
            'merchantApiSecretKey' => $this->merchantApiSecretKey
        ];
    }
}
