<?php

namespace Modules\Payments\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Modules\ServiceHelper\app\Models\Images;

class PaymentGateway extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table = 'payment_gateways';
    
    protected $fillable = [
        'id',
        'paymentGatewayName',
        'merchantId',
        'merchantApiSecretKey',
        'status'
    ];
    public function images(): HasMany
    {
        return $this->hasMany(Images::class);
    }
}
