<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\PaymentGatewayStatus;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_gateways', function (Blueprint $table) {
            $table->id();
            $table->string('paymentGatewayName');
            $table->string('merchantId')->nullable();
            $table->string('merchantApiSecretKey')->nullable();
            $table->enum('status', PaymentGatewayStatus::TYPES)->default(PaymentGatewayStatus::DEACTIVATED);           
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_gateways');
    }
};
