<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\Payments\app\Http\Controllers\Api\v1\PaymentGatewayApiController;
use Modules\Payments\app\Http\Controllers\Api\v1\PaymentApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

Route::middleware(['auth:api','administrator'])->group(function () {
    Route::post('/payment_gateways',[PaymentGatewayApiController::class,'store'])->name('payment_gateways.store');
    Route::put('/payment_gateways/{id}',[PaymentGatewayApiController::class,'update'])->name('payment_gateways.update');
    Route::delete('/payment_gateways/{id}',[PaymentGatewayApiController::class,'destroy'])->name('payment_gateways.destroy');
    Route::put('/payment_gateways/inactive/{id}',[PaymentGatewayApiController::class,'inactive'])->name('payment_gateways.inactive');
    Route::put('/payment_gateways/active/{id}',[PaymentGatewayApiController::class,'active'])->name('payment_gateways.active');
    Route::get('/getPaymentGatewayWithActivedStatus',[PaymentGatewayApiController::class,'getPaymentGatewayWithActivedStatus'])->name('payment_gateways.getPaymentGatewayWithActivedStatus');



});

// ================= api routes ============== //
//Route::get('/category',[CategoryApiController::class,'index'])->name('category.index');
//Route::middleware(['auth:api'])->group(function () {
    Route::get('/payment_gateways',[PaymentGatewayApiController::class,'index'])->name('payment_gateways.index');
    Route::get('/payment_gateways/{id}',[PaymentGatewayApiController::class,'show'])->name('payment_gateways.show');
    Route::post('/payment',[PaymentApiController::class,'store'])->name('payment.store');
//});
