<?php

namespace Modules\Products\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Products\app\Models\Product;
use Modules\ServiceHelper\app\Models\Discont;
use Modules\Products\app\Http\Resources\ProductResource;
use Modules\Products\app\Http\Requests\StoreProductRequest;
use Modules\Products\app\Http\Requests\UpdateProductRequest;
use App\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use App\Helpers\GenerateRandomStringHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\UploadedFile;
use Intervention\Image\ImageManager;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image as Image;
//use App\Helpers\ImagesHelper;
use Modules\ServiceHelper\app\Models\Images;
use Modules\ServiceHelper\app\Http\Resources\ImageResource;
use Illuminate\Support\Facades\DB;

class ProductApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $products = Product::all();
        return sendResponse(ProductResource::collection($products), 'Products retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
            $product = new Product();
            $product->reference = generateRandomString(8);
            $product->name = $request->name;
            $product->alias = $request->alias;
            $product->full_description = $request->full_description;
            $product->short_description = $request->short_description;
            $product->price = $request->price;
            $product->size_id = $request->size_id;
            $product->currency_id = $request->currency_id;
            $product->color = $request->color;
            $product->state = $request->state;
            $product->material = $request->material;
            $product->total_quantity= $request->total_quantity;
            $product->weight = $request->weight;
            $product->brend_id = $request->brend_id;
            $product->category_id = $request->category_id;
            $product->department_id = $request->department_id;

            $product->save();

            if ($product) {
                $discont = new Discont();
                $discont->value = $request->discont_value;
                $discont->product_id = $product->id;
                $discont->save();
            };
        
            $images = $request->images;

            foreach($images as $key => $file){
            $filename = $file['filename'];
            $filepath = $file['pathname'];
            $folder = 'multimedia/products/';
            if (!file_exists(public_path($folder))) {
                mkdir(public_path($folder), 777, true);
            }
            $path = $folder .$filename;
            $image = Image::make(file_get_contents($filepath))
                ->resize(320, 453)
                ->save(public_path().'/' .$path );


                if ($product) {
                    $picture = new Images();
                    $picture->api_server_path = config('app.url') .'/';
                    $picture->folder = $folder;
                    $picture->filename = $filename;
                    $picture->alt_filename = $filename;
                    $picture->product_id = $product->id;
                    $picture->save();
                };
            }


        return sendResponse(new ProductResource($product), 'Product created successfully.');
    }
    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        $product = Product::findOrFail($id);

        if (is_null($product)) {

                return sendError(new ProductResource($product), 'Product not found, status false!');

            }elseif ( $product->availability_status == 'available') {

            return sendResponse(new ProductResource($product), 'Product retrieved successfully, status true!');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Product $id)
    {
        $id->update($request->all());

        return  sendResponse(new ProductResource($id), 'Product updated successfully.');
    }

    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        $product = Product::find($id);
        $product->delete();
        return  sendResponse([],'Product deleted successfully.');
    }

    public function getProductWithPaginate()
    {
        $products = Product::paginate(2);

        return sendResponse(ProductResource::collection($products), 'Products retrieved successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id): JsonResponse
    {
        DB::table('products')
            ->where('id', $id)
            ->update(['status' => ProductActiveStatus::DEACTIVATED]);
        return  sendResponse(new ProductResource($id), 'The product is successfully deactivated.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function active($id): JsonResponse
    {
        DB::table('products')
            ->where('id', $id)
            ->update(['status' => ProductActiveStatus::ACTIVATED]);
        return  sendResponse(new ProductResource($id), 'The product has been successfully activated.');
    }
   // public function getProductsFromCategory($id)
    //{
    //    $products = Product::where('category_id','=',$id)->get();
   //     return sendResponse(ProductResource::collection($products), 'Products retrieved successfully.');
   // }
}
