<?php

namespace Modules\Products\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreProductRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
        'image' =>'nullable',
        'name'   => 'required', 'string', 'max:255',
        'alias' => 'required', 'string', 'max:255',       
        'full_description'  => 'required', 'text',
        'short_description'  => 'required', 'text',
        'price' => 'required', 'float',
        'size_id' => 'nullable',
        'currency_id' => 'nullable',
        'color'=>'required',
        'status'=>'required',
        'state'=>'required',
        'availability_status'=>'nullable',
        'category_id' => 'nullable',
        'brend_id' => 'nullable',
        'image_id' => 'nullable',
        'discont_id' => 'nullable',
        'department_id' => 'nullable'
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
