<?php

namespace Modules\Products\app\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Category\app\Http\Resources\CategoryResource;
use Modules\ServiceHelper\app\Http\Resources\CurrencyResource;
use Modules\ServiceHelper\app\Http\Resources\SizeResource;
use Modules\Department\app\Http\Resources\DepartmentResource;
use Modules\ServiceHelper\app\Http\Resources\ImageResource;
use Modules\ServiceHelper\app\Http\Resources\BrendResource;
use Modules\ServiceHelper\app\Http\Resources\DiscontResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'reference' => $this->reference,
            'name' => $this->name,
            'alias' => $this->alias,
            'image' => ImageResource::collection($this->images), 
            'status' => $this->status,
            'full_description' => $this->full_description,
            'short_description' => $this->short_description,
            'price' => $this->price,
            'discont' =>  DiscontResource::collection($this->disconts),
            'brend' => new BrendResource($this->brend),
            'currency' => new CurrencyResource($this->currency),
            'size' => new SizeResource($this->size),
            'color'=>$this->color,
            'state'=>$this->state,
            'weight'=>$this->weight,
            'availability_status'=>$this->availability_status,
            'category' => new CategoryResource($this->category),
            'department' => new DepartmentResource($this->department),
            'created_at'=> $this->created_at,
            'pivot_quantity'=> $this->whenPivotLoaded('basket_product', function(){
                return $this->pivot->quantity;
                }),
            'pivot_price'=> $this->whenPivotLoaded('basket_product', function(){
                    return $this->pivot->price;
                }),
                'pivot_price_with_discont'=> $this->whenPivotLoaded('basket_product', function(){
                    return $this->pivot->price_with_discont;
                    }),
                'pivot_product_discont'=> $this->whenPivotLoaded('basket_product', function(){
                        return $this->pivot->product_discont;
                    }),  
            ];
        }
}
