<?php

namespace Modules\Products\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Products\Database\factories\ProductFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Modules\Category\app\Models\Category;
use Modules\Department\app\Models\Department;
use Modules\ServiceHelper\app\Models\Currency;
use Modules\ServiceHelper\app\Models\Size;
use Modules\ServiceHelper\app\Models\Images;
use Modules\ServiceHelper\app\Models\Brend;
use Modules\ServiceHelper\app\Models\Discont;
use Modules\Orders\app\Models\Basket;

class Product extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table = 'products';

    protected $casts = [
        'image' => 'array',
        ];
        
    protected $fillable = [
        'id',
        'reference',
        'name',
        'alias',
        'image',
        'status',
        'full_description',
        'short_description',
        'price',
        'currency_id',
        'size_id',
        'brend_id',
        'color',
        'state',
        'weight',
        'material',
        'total_quantity',
        'availability_status',
        'status',
        'category_id',
        'department_id',
    ];
    
    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }
    
    public function department(): BelongsTo
    {
        return $this->belongsTo(Department::class);
    }
    
    public function currency(): BelongsTo
    {
        return $this->belongsTo(Currency::class);
    }
    
    public function size(): BelongsTo
    {
        return $this->belongsTo(Size::class);
    }

    public function images(): HasMany
    {
        return $this->hasMany(Images::class);
    }
    
    public function brend():BelongsTo
    {
        return $this->belongsTo(Brend::class);
    }

    public function disconts():HasMany
    {
        return $this->hasMany(Discont::class);
    }

    public function baskets():BelongsToMany
    {
        return $this->belongsToMany(Basket::class)->withPivot('quantity','price','price_with_discont','product_discont','product_weight');
    }
}
