<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\ProductStatus;
use App\Enums\ProductActiveStatus;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('reference');
            $table->string('name');
            $table->string('alias');
            $table->string('image')->default('default.jpg');
            $table->text('full_description');
            $table->text('short_description');
            $table->float('price');
            $table->float('weight');
            $table->integer('total_quantity');
            $table->string('material');
            $table->foreignId('currency_id')->nullable()->constrained()->cascadeOnDelete();
            $table->foreignId('size_id')->nullable()->constrained()->cascadeOnDelete();
            //$table->foreignId('discont_id')->nullable()->constrained()->cascadeOnDelete();
            $table->foreignId('brend_id')->nullable()->constrained()->cascadeOnDelete();
            $table->string('color');
            $table->string('state');
            $table->foreignId('category_id')->nullable()->constrained()->cascadeOnDelete();
            $table->foreignId('department_id')->nullable()->constrained()->cascadeOnDelete();
            $table->enum('availability_status', ProductStatus::TYPES)->default(ProductStatus::AVAIBLE);
            $table->enum('status', ProductActiveStatus::TYPES)->default(ProductActiveStatus::DEACTIVATED);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
