<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\Products\App\Http\Controllers\Api\v1\ProductApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

// ================ admin routes ======================== //

Route::middleware(['auth:api','administrator'])->group(function () {
    Route::post('/product',[ProductApiController::class,'store'])->name('product.store');
    Route::put('/product/{id}',[ProductApiController::class,'update'])->name('product.update');
    Route::delete('/product/{id}',[ProductApiController::class,'destroy'])->name('product.destroy');
    Route::put('/product/inactive/{id}',[ProductApiController::class,'inactive'])->name('product.inactive');
    Route::put('/product/active/{id}',[ProductApiController::class,'active'])->name('product.active');
});

// ================= api routes ============== //
Route::get('/product',[ProductApiController::class,'index'])->name('product.index');
Route::get('/product/{id}',[ProductApiController::class,'show'])->name('product.show');
Route::get('/getProductWithPaginate',[ProductApiController::class,'getProductWithPaginate'])->name('product.getProductWithPaginate');
//
Route::middleware(['auth:api'])->group(function () {
    //Route::get('/product',[ProductApiController::class,'index'])->name('product.index');
    //Route::get('/product/{id}',[ProductApiController::class,'show'])->name('product.show');
});
