<?php

namespace Modules\Promotion\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Promotion\app\Models\Promotion;
use Modules\Promotion\app\Http\Resources\PromotionResource;
use Modules\Promotion\app\Http\Requests\StorePromotionRequest;
use Modules\Promotion\app\Http\Requests\UpdatePromotionRequest;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Appp\Helpers\GenerateRandomString;
use \App\Helpers\UploadOriginalImageHelper;
use \App\Helpers\UploadMediumImageHelper;
use \App\Helpers\UploadSmallImageHelper;
use Appp\Helpers\ImagesHelper;
use Intervention\Image\Facades\Image as Image;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\ImageManager;
use Modules\ServiceHelper\app\Models\Images;
use Modules\ServiceHelper\app\Http\Resources\ImageResource;
use App\Enums\PromotionStatus;

class PromotionApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $promotions = Promotion::all();
        return sendResponse(PromotionResource::collection($promotions), 'Promotion retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {

        $promotion = new Promotion();
        $promotion->name = $request->name;
        $promotion->description = $request->description;

        $filename = $request->image['filename'];
        $filepath = $request->image['pathname'];

        $folder = 'multimedia/promotions/';

        if (!file_exists(public_path($folder))) {
            mkdir(public_path($folder), 777, true);
        }
        $path = $folder .$filename;

        $image = Image::make(file_get_contents($filepath))->save(public_path().'/' .$path );
        $promotion->save();

        if ($promotion) {
            $picture = new Images();
            $picture->api_server_path = config('app.url') .'/';
            $picture->folder = $folder;
            $picture->filename = $filename;
            $picture->alt_filename = $filename;
            $picture->promotion_id = $promotion->id;
            $picture->save();
        };
        
        
        return sendResponse( new PromotionResource($promotion), 'Promotion created successfully.');
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        $promotion  = Promotion::findOrFail($id);

        if (is_null($promotion )) {

                return sendError(new SharesResource($share), 'Promotion not found, status false!');

            }elseif ( $promotion ->status == 'activated') {

            return sendResponse(new PromotionResource($share), 'Promotion retrieved successfully, status true!');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Promotion $id)
    {
        $id->update($request->all());

        return  sendResponse(new PromotionResource($id), 'Promotion updated successfully.');
    }

    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id): JsonResponse
    {
        $promotion = Promotion::find($id);
        $promotion ->delete($id);
        return  sendResponse([],'Promotion deleted successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id): JsonResponse
    {
        DB::table('promotions')
            ->where('id', $id)
            ->update(['status' => PromotionStatus::DEACTIVATED]);

        return  sendResponse(new PromotionResource($id), 'The promotion is successfully deactivated.');
    }

    /**
     * Update the specified resource in storage.
     */

    public function active($id): JsonResponse
    {
        DB::table('promotions')
            ->where('id', $id)
            ->update(['status' => PromotionStatus::ACTIVATED]);

        return  sendResponse(new PromotionResource($id), 'The promotion has been successfully activated.');
    }

}
