<?php

namespace Modules\Promotion\app\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\ServiceHelper\app\Http\Resources\ImageResource;

class PromotionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'image' => ImageResource::collection($this->images),          
            'status' => $this->status,
            ];
    }
}
