<?php

namespace Modules\Promotion\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Promotion\Database\factories\PromotionFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Modules\ServiceHelper\app\Models\Images;

class Promotion extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table = 'promotions';

    protected $fillable = [
        'id',
        'name',
        'description',
        'status',
        'image',
    ];
    
    public function images(): HasMany
    {
        return $this->hasMany(Images::class);
    }
}
