<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\Promotion\app\Http\Controllers\Api\v1\PromotionApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

// ================ admin routes ======================== //
Route::get('/getPromotionWithActivedStatus',[PromotionApiController::class,'getPromotionWithActivedStatus'])->name('promotion.getPromotionWithActivedStatus');
Route::middleware(['auth:api','administrator'])->group(function () {
    Route::post('/promotion',[PromotionApiController::class,'store'])->name('promotion.store');
    Route::put('/promotion/{id}',[PromotionApiController::class,'update'])->name('promotion.update');
    Route::delete('/promotion/{id}',[PromotionApiController::class,'destroy'])->name('promotion.destroy');
    Route::put('/promotion/inactive/{id}',[PromotionApiController::class,'inactive'])->name('promotion.inactive');
    Route::put('/promotion/active/{id}',[PromotionApiController::class,'active'])->name('promotion.active');




});

// ================= api routes ============== //

Route::middleware(['auth:api'])->group(function () {
    Route::get('/promotion',[PromotionApiController::class,'index'])->name('promotion.index');
    Route::get('/promotion/{id}',[PromotionApiController::class,'show'])->name('promotion.show');
    
});