<?php

namespace Modules\ServiceHelper\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\ServiceHelper\app\Models\Brend;
use Modules\ServiceHelper\app\Http\Resources\BrendResource;
use Modules\ServiceHelper\app\Http\Requests\StoreBrendRequest;
use Modules\ServiceHelper\app\Http\Requests\UpdateBrendRequest;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Helpers\GenerateRandomString;
use App\Enums\BrendStatus;

class BrendApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $brends = Brend::all();
        return sendResponse(BrendResource::collection($brends), 'Brend retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = new Brend();
        $data->name = $request->name;
        $data->alias = $request->alias;
        $data->save();

        return sendResponse(new BrendResource($data), 'Brend created successfully.');
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        $brend = Brend::findOrFail($id);

        if (is_null($brend)) {

                return sendError(new BrendResource($brend), 'Brend not found, status false!');

            }elseif ( $brend->status == 'activated') {

            return sendResponse(new BrendResource($brend), 'Brend retrieved successfully, status true!');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Brend $id)
    {
        $id->update($request->all());

        return  sendResponse(new BrendResource($id), 'Brend updated successfully.');
    }

    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        $brend = Brend::find($id);
        $brend->delete($id);
        return  sendResponse([],'Brend deleted successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id)
    {
        DB::table('brends')
            ->where('id', $id)
            ->update(['status' => BrendStatus::DEACTIVATED]);

        return  sendResponse(new BrendResource($id), 'The brend is successfully deactivated.');
    }

    /**
     * Update the specified resource in storage.
     */

    public function active($id)
    {
        DB::table('brends')
            ->where('id', $id)
            ->update(['status' => BrendStatus::ACTIVATED]);
        return  sendResponse(new BrendResource($id), 'The brend has been successfully activated.');
    }

}
