<?php

namespace Modules\ServiceHelper\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\ServiceHelper\app\Models\Currency;
use Modules\ServiceHelper\app\Http\Resources\CurrencyResource;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Helpers\GenerateRandomString;
use App\Enums\CurrencyStatus;

class CurrencyApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $currencies = Currency::all();
        return sendResponse(CurrencyResource::collection($currencies), 'Currencies retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        
        $data = new Currency();
        $data->name = $request->name;
        $data->alias = $request->alias;
        $data->save();

        return sendResponse(new CurrencyResource($data), 'Currency created successfully.');
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        $currency = Currency::findOrFail($id);

        if (is_null($currency)) {

                return sendError(new CurrencyResource($currency), 'Currency not found, status false!');

            }elseif ( $currency->status == 'activated') {

            return sendResponse(new CurrencyResource($currency), 'Currency retrieved successfully, status true!');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Currency $id)
    {
        $id->update($request->all());

        return  sendResponse(new CurrencyResource($id), 'Currency updated successfully.');
    }

    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        $currency = Currency::find($id);
        $currency->delete($id);
        return  sendResponse([],'Currency deleted successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id)
    {
        DB::table('currencies')
            ->where('id', $id)
            ->update(['status' => CurrencyStatus::DEACTIVATED]);

        return  sendResponse(new CurrencyResource($id), 'The currency is successfully deactivated.');
    }

    /**
     * Update the specified resource in storage.
     */

    public function active($id)
    {
        DB::table('currencies')
            ->where('id', $id)
            ->update(['status' => CurrencyStatus::ACTIVATED]);
        return  sendResponse(new CurrencyResource($id), 'The currency has been successfully activated.');
    }
}
